
//
//  HSMacro.h
//  HSCore
//
//  Created by Kyle Hankinson on 2018-10-05.
//  Copyright © 2018 Hankinsoft Development, Inc. All rights reserved.
//

#ifndef HSMacro_h
#define HSMacro_h

#import "Defer.h"
#import "MachTimer.h"

#define mustOverride() {\
NSString * logString = [NSString stringWithFormat:@"%@ must be overridden in a subclass/category", NSStringFromSelector(_cmd)];\
NSLog(@"%@", logString);\
@throw [NSException exceptionWithName:NSInvalidArgumentException reason: logString userInfo:nil]; \
}

#define LogEnterExitMeasure() {\
MachTimer * hsMeasureFunctionTimer = [MachTimer startTimer];\
[HSLogHelper.sharedInstance logMessage: @"-- <Enter %@:%@:%d>", NSStringFromClass([self class]), NSStringFromSelector(_cmd), __LINE__];\
pspdf_defer {\
NSLog(@"-- <Exit %@:%@:%d> took %0.2f seconds%@.", NSStringFromClass([self class]), NSStringFromSelector(_cmd), __LINE__, hsMeasureFunctionTimer.elapsedSeconds, hsMeasureFunctionTimer.elapsedSeconds > 1 ? @"(slow)" : @"");\
};\
}
#endif /* HSMacro_h */
